package software.bernie.geckolib3.renderers.geo;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.geckolib3.model.AnimatedGeoModel;

import java.awt.*;
import java.util.Collections;
import java.util.Objects;

public abstract class GeoItemRenderer<T extends Item & IAnimatable> extends TileEntityItemStackRenderer implements IGeoRenderer<T>
{
	// Register a model fetcher for this renderer
	static
	{
		AnimationController.addModelFetcher((IAnimatable object) ->
		{
			if (object instanceof Item)
			{
				Item item = (Item) object;
				TileEntityItemStackRenderer renderer = item.getTileEntityItemStackRenderer();
				if (renderer instanceof GeoItemRenderer)
				{
					return ((GeoItemRenderer<?>) renderer).getGeoModelProvider();
				}
			}
			return null;
		});
	}

	protected AnimatedGeoModel<T> modelProvider;
	protected ItemStack currentItemStack;
	public GeoItemRenderer(AnimatedGeoModel<T> modelProvider)
	{
		this.modelProvider = modelProvider;
	}

	public void setModel(AnimatedGeoModel<T> model)
	{
		this.modelProvider = model;
	}

	@Override
	public AnimatedGeoModel<T> getGeoModelProvider()
	{
		return modelProvider;
	}

	@Override
	public void renderByItem(ItemStack itemStack, float partialTicks)
	{
		this.render((T) itemStack.getItem(), itemStack);
	}

	public void render(T animatable, ItemStack itemStack)
	{
		this.currentItemStack = itemStack;
		GeoModel model = modelProvider.getModel(modelProvider.getModelLocation(animatable));
		AnimationEvent itemEvent = new AnimationEvent(animatable, 0, 0, Minecraft.getMinecraft().getRenderPartialTicks(), false, Collections.singletonList(itemStack));
		modelProvider.setLivingAnimations(animatable, this.getUniqueID(animatable), itemEvent);
		GlStateManager.pushMatrix();
		GlStateManager.translate(0, 0.01f, 0);
		GlStateManager.translate(0.5, 0.5, 0.5);

		Minecraft.getMinecraft().renderEngine.bindTexture(getTextureLocation(animatable));
		Color renderColor = getRenderColor(animatable, 0f);
		render(model, animatable, 0f, (float) renderColor.getRed() / 255f, (float) renderColor.getGreen() / 255f, (float) renderColor.getBlue() / 255f, (float) renderColor.getAlpha() / 255);
		GlStateManager.popMatrix();
	}

	@Override
	public ResourceLocation getTextureLocation(T instance)
	{
		return this.modelProvider.getTextureLocation(instance);
	}

	@Override
	public Integer getUniqueID(T animatable)
	{
		return Objects.hash(currentItemStack.getItem(), currentItemStack.getCount(), currentItemStack.hasTagCompound() ? currentItemStack.getTagCompound().toString() : 1);
	}
}
